/*
 * Decompiled with CFR 0.152.
 */
package com.sinaflying.game;

import com.sinaflying.customise.Function;
import com.sinaflying.engine.GameMIDlet;
import com.sinaflying.engine.KeyCode;
import com.sinaflying.game.GameInterface;
import com.sinaflying.game.Scene;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;

public final class GameMainLogic
extends Canvas {
    private static GameMainLogic _inst;
    public static GameInterface _interface;
    public static Scene _scene;
    public static KeyCode _keycode;
    protected boolean _painting;
    protected static byte _state;
    protected byte _lastState;
    protected byte _loadProcess;
    protected byte _level;
    public static int _gameScenario;
    public static int _gameTaskMan;
    public static int _gameTaskState;
    public static int _gameTaskIndex;
    public GameMIDlet _midlet;
    private long _gameStartTime;
    private long _gamePlayTime;

    private GameMainLogic(GameMIDlet gameMIDlet) {
        this.setFullScreenMode(true);
        _interface = GameInterface.getInstance(this);
        _keycode = KeyCode.instance(this);
        _keycode.initTouchScreen();
        _state = 0;
        this._midlet = gameMIDlet;
        this._painting = false;
    }

    public static final GameMainLogic produceGameMainLogic(GameMIDlet gameMIDlet) {
        _inst = new GameMainLogic(gameMIDlet);
        return _inst;
    }

    public static final GameMainLogic getInstance() {
        return _inst;
    }

    public final void paint(Graphics graphics) {
        this._painting = true;
        graphics.setFont(Function.C_GAME_FONT);
        try {
            switch (_state) {
                case 0: {
                    _interface.paint(graphics);
                    break;
                }
                case 1: {
                    _scene.update();
                    _scene.paint(graphics);
                    break;
                }
                case 2: {
                    this.drawStopFrame(graphics);
                    break;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean paintable() {
        return this._painting;
    }

    private void drawStopFrame(Graphics graphics) {
        Function.fillScreen(graphics, 0, 0, 240, 320, 0);
        Function.draw3DString(graphics, "Tr\u00f2 ch\u01a1i t\u1ea1m d\u1eebng", 120, 160, 0x10 | 1, 0xFFFFFF, 0);
        Function.draw3DString(graphics, "Tr\u1edf v\u1ec1", 230, 312, 8 | 0x20, 0xFFFFFF, 0);
        if (KeyCode.isPressCancelKey()) {
            KeyCode.resetCurKey();
            this.backGameState();
        }
    }

    public void backGameState() {
        _state = this._lastState;
        Function.continuePlaySound();
    }

    public void changeState(byte by) {
        if (_state != by) {
            this._lastState = _state;
            _state = by;
        }
        KeyCode.resetCurKey();
    }

    public void startRecordGameTime() {
        this._gameStartTime = System.currentTimeMillis() / 1000L;
    }

    public void resetGamePlayingTime() {
        this._gameStartTime = 0L;
        this._gamePlayTime = 0L;
    }

    public void countPlayGameTime() {
        this._gamePlayTime += System.currentTimeMillis() / 1000L - this._gameStartTime;
        this.startRecordGameTime();
    }

    public byte[] returnTimeArray() {
        byte[] byArray = new byte[]{0, 0};
        this.countPlayGameTime();
        byArray[0] = (byte)(this._gamePlayTime / 60L / 60L);
        byArray[1] = (byte)(this._gamePlayTime / 60L % 60L);
        return byArray;
    }

    public void setContinueGameTime(int[] nArray) {
        this._gamePlayTime = (nArray[0] * 60 + nArray[1]) * 60;
        this.startRecordGameTime();
    }

    public final void changeLevel(byte by) {
        this._level = by;
    }

    public int getLevel() {
        return this._level;
    }

    public final void loadLevelData(Graphics graphics) {
        switch (this._loadProcess) {
            case 0: {
                if (_scene != null) {
                    _scene.dispose();
                }
                _interface.resetLoadProcess();
                this.changeProcess((byte)1);
                break;
            }
            case 1: {
                if (GameInterface._isZuoBi && !GameInterface._closePartInfo && Integer.parseInt(GameInterface._paraValue[0]) >= 0) {
                    this._level = (byte)Integer.parseInt(GameInterface._paraValue[0]);
                    GameInterface._closePartInfo = true;
                }
                if (!Scene.produceScene(this, this._level)) break;
                _scene = Scene.getInstance();
                this.changeProcess((byte)2);
                break;
            }
            case 2: {
                this.changeProcess((byte)3);
            }
            case 3: {
                this.changeProcess((byte)4);
                break;
            }
            case 4: {
                this.changeProcess((byte)5);
                break;
            }
            case 5: {
                this.changeProcess((byte)6);
                break;
            }
            case 6: {
                this.changeProcess((byte)7);
                break;
            }
            case 7: {
                this.changeProcess((byte)8);
                break;
            }
            case 8: {
                this.changeProcess((byte)9);
                break;
            }
            case 9: {
                if (this._loadProcess < 9) break;
                _scene.startup();
                this.changeState((byte)1);
                this.changeProcess((byte)0);
            }
        }
    }

    private final void changeProcess(byte by) {
        this._loadProcess = by;
    }

    public final void keyPressed(int n) {
        _keycode.keyPressed(n);
    }

    public final void keyReleased(int n) {
        _keycode.keyReleased(n);
    }

    protected void pointerPressed(int n, int n2) {
        _keycode.pointerPressed(n, n2);
    }

    protected void pointerReleased(int n, int n2) {
        _keycode.pointerReleased(n, n2);
    }

    public void hideNotify() {
        Function.stopSound();
        if (Scene._state != 3) {
            this.changeState((byte)2);
        }
    }
}

